
// Coordinates of cities on the PNG map (en pixels)
// Tu devras mettre à jour ces valeurs en fonction des coordonnées réelles
let cityCoordinates = {
    "Towns* : These towns are not served by airships": { x: 150, y: 1 }, //Legend
    "Achirnolm*": { x: 504, y: 404 }, //non desservie
    "Ammeric*": { x: 583, y: 791 }, //non desservie
    "Asandam": { x: 34, y: 425 },
    "Bapa": { x: 968, y: 112 },
    "Bismed": { x: 632, y: 1000 },
    "Bleim*": { x: 86, y: 473 }, //non desservie
    "Bohkh": { x: 376, y: 105 },
    "Brondostin": { x: 845, y: 36 },
    "Cen*": { x: 301, y: 1005 }, //non desservie
    "Elah": { x: 693, y: 1051 },
    "Endidrelic*": { x: 77, y: 636 }, //non desservie
    "Eson*": { x: 511, y: 505 }, //non desservie
    "Flelnenberg*": { x: 454, y: 955 }, //non desservie
    "Floswowan*": { x: 867, y: 496 }, //non desservie
    "Gbuzoubou": { x: 901, y: 75 },
    "Grelic": { x: 512, y: 645 },
    "Haric*": { x: 443, y: 568 }, //non desservie
    "Klioereos": { x: 526, y: 31 },
    "Mahhir": { x: 934, y: 691 },
    "Masafa": { x: 1004, y: 855 },
    "Meham": { x: 969, y: 758 },
    "Molam": { x: 1038, y: 792 },
    "Molmed": { x: 988, y: 643 },
    "Mosaiikoubi": { x: 775, y: 784 },
    "Naussimore*": { x: 97, y: 359 }, //non desservie
    "Nelm*": { x: 235, y: 921 }, //non desservie
    "Ntembe": { x: 173, y: 924 },
    "Ondeasalic": { x: 975, y: 193 },
    "Ornoria*": { x: 157, y: 530 }, //non desservie
    "Phokles": { x: 784, y: 294 },
    "Prelm*": { x: 535, y: 294 }, //non desservie
    "Raafa": { x: 1026, y: 726 },
    "Rawad": { x: 841, y: 756 },
    "Rezealvan": { x: 952, y: 552 },
    "Shaif": { x: 864, y: 1003 },
    "Staling*": { x: 71, y: 558 }, //non desservie
    "Stosson*": { x: 400, y: 990 }, //non desservie
    "Sowen*": { x: 621, y: 350 }, //non desservie
    "Taling*": { x: 534, y: 574 }, //non desservie
    "Tograd*": { x: 289, y: 231 }, //non desservie
    "Wamad": { x: 1073, y: 692 },
    "Yazaiertab": { x: 903, y: 896 },
    "Zorafa*": { x: 790, y: 896 } //non desservie
};


// Load travel times if the CSV is not available
function loadTravelTimes() {
    travelTimes = {};
    const matriceTemps = {
        // multiplicateur GIMP pixels / secondes : 1.315
        "Asandam": { "Asandam": 0, "Bapa": 1292, "Gbuzoubou": 1237, "Molmed": 1288, "Grelic": 687 },
        "Bapa": { "Bapa": 0, "Bohkh": 769, "Gbuzoubou": 98, "Asandam": 1292, "Shaif": 1175 },
        "Bismed": { "Bismed": 0, "Grelic": 493, "Shaif": 298, "Mosaiikoubi": 340 },
        "Bohkh": { "Bohkh": 0, "Bapa": 769, "Elah": 1315, "Rezealvan": 963 },
        "Brondostin": { "Brondostin": 0, "Klioereos": 418, "Molmed": 825, "Rezealvan": 693, "Molam": 1029 },
        "Elah": { "Elah": 0, "Bohkh": 1315, "Mahhir": 574, "Meham": 528 },
        "Gbuzoubou": { "Gbuzoubou": 0, "Bapa": 98, "Klioereos": 503, "Asandam": 1237, "Raafa": 863 },
        "Grelic": { "Grelic": 0, "Bismed": 493, "Ntembe": 577, "Wamad": 752, "Asandam": 687 },
        "Klioereos": { "Klioereos": 0, "Wamad": 1138, "Gbuzoubou": 503, "Brondostin": 418, "Yazaiertab": 1243 },
        "Mahhir": { "Mahhir": 0, "Phokles": 558, "Raafa": 134, "Elah": 574, "Shaif": 424 },
        "Masafa": { "Masafa": 0, "Yazaiertab": 143, "Raafa": 173, "Wamad": 236, "Phokles": 790 },
        "Meham": { "Meham": 0, "Molmed": 152, "Ntembe": 1067, "Elah": 528, "Ondeasalic": 740 },
        "Molmed": { "Molmed": 0, "Brondostin": 825, "Meham": 152, "Asandam": 1288, "Yazaiertab": 352 },
        "Molam": { "Molam": 0, "Yazaiertab": 9999, "Brondostin": 9999, "Rezealvan": 9999 },
        // "Molam": { "Molam": 0, "Yazaiertab": 220, "Brondostin": 1029, "Rezealvan": 336 },
        "Mosaiikoubi": { "Mosaiikoubi": 0, "Wamad": 423, "Bismed": 340, "Ondeasalic": 821 },
        "Ntembe": { "Ntembe": 0, "Rezealvan": 1137, "Meham": 1067, "Grelic": 577, "Rawad": 909 },
        "Ondeasalic": { "Ondeasalic": 0, "Mosaiikoubi": 821, "Phokles": 282, "Rawad": 758, "Meham": 740 },
        "Phokles": { "Phokles": 0, "Ondeasalic": 282, "Rawad": 614, "Masafa": 790, "Mahhir": 558 },
        "Raafa": { "Raafa": 0, "Masafa": 173, "Gbuzoubou": 863, "Mahhir": 134, "Rawad": 241 },
        "Rawad": { "Rawad": 0, "Ntembe": 909, "Phokles": 614, "Raafa": 241, "Ondeasalic": 758 },
        "Rezealvan": { "Rezealvan": 0, "Molam": 336, "Brondostin": 693, "Bohkh": 963, "Ntembe": 1137 },
        // "Shaif": { "Shaif": 0, "Bapa": 1175, "Bismed": 298, "Mahhir": 424 },
        "Shaif": { "Shaif": 0, "Bapa": 9999, "Bismed": 9999, "Mahhir": 9999 },
        "Wamad": { "Wamad": 0, "Grelic": 752, "Masafa": 236, "Mosaiikoubi": 423, "Klioereos": 1138 },
        "Yazaiertab": { "Yazaiertab": 0, "Molmed": 352, "Molam": 220, "Masafa": 143, "Klioereos": 1243 }
    };
    console.log(`Total number of towns: ${Object.keys(matriceTemps).length}`);
    Object.keys(matriceTemps).forEach(fromCity => {
        travelTimes[fromCity] = {};
        Object.keys(matriceTemps).forEach(toCity => {
            travelTimes[fromCity][toCity] = (matriceTemps[fromCity][toCity] !== undefined)
                ? matriceTemps[fromCity][toCity]
                : Infinity;
        });
        travelTimes[fromCity][fromCity] = 0;
    });
}

// Sample data if the HTML table is not accessible
function loadData() {
    // empty cities : Achirnolm, bleim, cen, naussimore, tograd, Eson, Taling, Tograd, Haric, Flelnenberg, Floswowan, Prelm, Stosson, Nelm
    // Sowen, Ornoria, endidrelic, staling, Zorafa
    // TO DO :
    cities = ['Asandam','Bapa', 'Bismed', 'Bohkh', 'Brondostin', 'Elah', 'Gbuzoubou', 'Grelic',
        'Klioereos', 'Mahhir', 'Masafa', 'Meham', 'Molam', 'Molmed', 'Mosaiikoubi', 'Ntembe', 'Ondeasalic',
        'Phokles', 'Raafa', 'Rawad', 'Rezealvan', 'Shaif','Wamad', 'Yazaiertab']
    console.log(cities);
    connections = {};
    cities.forEach(city => {
        connections[city] = {};
        cities.forEach(otherCity => {
            connections[city][otherCity] = Infinity;
        });
        connections[city][city] = 0;
    });
    // configuration for connections
    connections['Asandam']['Bapa'] = 1;
    connections['Asandam']['Gbuzoubou'] = 1;
    connections['Asandam']['Molmed'] = 1;
    connections['Asandam']['Grelic'] = 1;

    connections['Bapa']['Bohkh'] = 1;
    connections['Bapa']['Gbuzoubou'] = 1;
    connections['Bapa']['Asandam'] = 1;
    connections['Bapa']['Shaif'] = 1;

    connections['Bismed']['Grelic'] = 1;
    connections['Bismed']['Shaif'] = 1;
    connections['Bismed']['Mosaiikoubi'] = 1;

    connections['Bohkh']['Bapa'] = 1;
    connections['Bohkh']['Elah'] = 1;
    connections['Bohkh']['Rezealvan'] = 1;

    connections['Brondostin']['Klioereos'] = 1;
    connections['Brondostin']['Molmed'] = 1;
    connections['Brondostin']['Rezealvan'] = 1;
    connections['Brondostin']['Molam'] = 1;

    connections['Elah']['Bohkh'] = 1;
    connections['Elah']['Mahhir'] = 1;
    connections['Elah']['Meham'] = 1;

    connections['Gbuzoubou']['Bapa'] = 1;
    connections['Gbuzoubou']['Klioereos'] = 1;
    connections['Gbuzoubou']['Asandam'] = 1;
    connections['Gbuzoubou']['Raafa'] = 1;

    connections['Grelic']['Bismed'] = 1;
    connections['Grelic']['Ntembe'] = 1;
    connections['Grelic']['Wamad'] = 1;
    connections['Grelic']['Asandam'] = 1;

    connections['Klioereos']['Wamad'] = 1;
    connections['Klioereos']['Gbuzoubou'] = 1;
    connections['Klioereos']['Brondostin'] = 1;
    connections['Klioereos']['Yazaiertab'] = 1;

    connections['Mahhir']['Phokles'] = 1;
    connections['Mahhir']['Raafa'] = 1;
    connections['Mahhir']['Elah'] = 1;
    connections['Mahhir']['Shaif'] = 1;

    connections['Masafa']['Yazaiertab'] = 1;
    connections['Masafa']['Raafa'] = 1;
    connections['Masafa']['Wamad'] = 1;
    connections['Masafa']['Phokles'] = 1;

    connections['Meham']['Molmed'] = 1;
    connections['Meham']['Ntembe'] = 1;
    connections['Meham']['Elah'] = 1;
    connections['Meham']['Ondeasalic'] = 1;

    connections['Molmed']['Brondostin'] = 1;
    connections['Molmed']['Meham'] = 1;
    connections['Molmed']['Asandam'] = 1;
    connections['Molmed']['Yazaiertab'] = 1;

// Molam
// connections['Molam']['Yazaiertab'] = 1;
// connections['Molam']['Brondostin'] = 1;
// connections['Molam']['Rezealvan'] = 1;
// connections['Molam']['Shaif'] = 1;

    connections['Mosaiikoubi']['Wamad'] = 1;
    connections['Mosaiikoubi']['Bismed'] = 1;
    connections['Mosaiikoubi']['Ondeasalic'] = 1;

    connections['Ntembe']['Rezealvan'] = 1;
    connections['Ntembe']['Meham'] = 1;
    connections['Ntembe']['Grelic'] = 1;
    connections['Ntembe']['Rawad'] = 1;

    connections['Ondeasalic']['Mosaiikoubi'] = 1;
    connections['Ondeasalic']['Phokles'] = 1;
    connections['Ondeasalic']['Rawad'] = 1;
    connections['Ondeasalic']['Meham'] = 1;

    connections['Phokles']['Ondeasalic'] = 1;
    connections['Phokles']['Rawad'] = 1;
    connections['Phokles']['Masafa'] = 1;
    connections['Phokles']['Mahhir'] = 1;


    connections['Raafa']['Masafa'] = 1;
    connections['Raafa']['Gbuzoubou'] = 1;
    connections['Raafa']['Mahhir'] = 1;
    connections['Raafa']['Rawad'] = 1;

    connections['Rawad']['Ntembe'] = 1;
    connections['Rawad']['Phokles'] = 1;
    connections['Rawad']['Raafa'] = 1;
    connections['Rawad']['Ondeasalic'] = 1;

    connections['Rezealvan']['Molam'] = 1;
    connections['Rezealvan']['Brondostin'] = 1;
    connections['Rezealvan']['Bohkh'] = 1;
    connections['Rezealvan']['Ntembe'] = 1;

// Shaif
// connections['Shaif']['Bapa'] = 1;
// connections['Shaif']['Bismed'] = 1;
// connections['Shaif']['Mahhir'] = 1;
// connections['Shaif']['Molam'] = 1;

    connections['Wamad']['Grelic'] = 1;
    connections['Wamad']['Masafa'] = 1;
    connections['Wamad']['Mosaiikoubi'] = 1;
    connections['Wamad']['Klioereos'] = 1;

    connections['Yazaiertab']['Molmed'] = 1;
    connections['Yazaiertab']['Molam'] = 1;
    connections['Yazaiertab']['Masafa'] = 1;
    connections['Yazaiertab']['Klioereos'] = 1;

    // Ces appels doivent se faire seulement si les éléments existent
    if (document.getElementById('startCity') && document.getElementById('endCity')) {
        populateDropdowns();
    }
    loadTravelTimes();
}
